$(function () {
    document.addEventListener("deviceready", onDeviceReady, false);

    $('#vibrate').click(function () {
        let rgb = Shake.shuffle();
        Pubnub.publish(rgb);
    });

    $('#colorWheel').blur(function () {
        let rgb = $(this).text();
        Pubnub.publish(rgb);
    });

    $('#colorBlock').on('click', 'span', function () {
        let rgb = $(this).data('rgb');
        Pubnub.publish(rgb);
    });

    $('#lightOff').click(function () {
        Pubnub.publish('000000');
    });
});

function onDeviceReady() {
    console.log('Device is ready');
    Shake.init();
    Pubnub.init();

    let colors = [
        'FF0000 255,0,0,1', '00FF00 0,255,0,1', '0000FF 0,0,255,1', 'FFFFFF 255,255,255,1',
        'BB0000 255,0,0,.7', '00BB00 0,255,0,.7', '0000BB 0,0,255,.7', 'BBBBBB 255,255,255,.7',
        '7A0000 255,0,0,.5', '007700 0,255,0,.5', '000077 0,0,255,.5', '7A7A7A 255,255,255,.5',
        '2A0000 255,0,0,.3', '002400 0,255,0,.3', '000024 0,0,255,.3', '2B2B2B 255,255,255,.3',
        '050000 255,0,0,.1', '000500 0,255,0,.1', '000005 0,0,255,.1', '050505 255,255,255,.1'
    ];

    for (let i = 0; i < colors.length; i++) {
        let c = colors[i].split(' ');
        $('#colorBlock').append(`
            <span class="waves-effect btn lime lighten-3" data-rgb="${c[0]}" style="border-bottom-color: rgba(${c[1]})">
                <i class="material-icons">lightbulb_outline</i></span>
            </span>
        `);
    }
}
