let Pubnub = function () {
    
    let publishKey = 'myPublishKey';
    let subscribeKey = 'mySubscribeKey';
    let channel = 'PIstrip';

    let init = function () {
        pubnub = new PubNub({
            subscribeKey: subscribeKey,
            publishKey: publishKey,
            ssl: true
        });

        pubnub.addListener({
            message: function (m) {
                console.log('addListener: message m', m);
                if (m.message.color) {
                    _changeColorWheel(m.message.color);
                }
            }
        });

        pubnub.subscribe({
            channels: [channel]
        });

        pubnub.history({
                channel: channel,
                count: 1
            },
            function (status, response) {
                console.log('history response', response);
                let color = response.messages[0].entry.color;
                _changeColorWheel(color);
            }
        );
    };

    let publish = function (rgb) {
        pubnub.publish({
            channel: channel,
            message: {
                color: rgb
            }
        });
    };

    let _changeColorWheel = function (color) {
        color = color.trim();
        try {
            $('#colorWheel').val(color);
            document.getElementById('colorWheel').jscolor.fromString(color);
        }
        catch (err) {
            console.log('ColorWheel error', err);
        }
    };

    return {
        init: init,
        publish: publish,
    };
}();